<?php

    include '../includes/connection.php';
    include '../includes/functions.php';
    session_start();

    if (isset($_SESSION['username'])) {
        header("Location: ../dashboard/");
        exit();
    }

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title>KeyAuth - Login</title>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="../assets/img/favicon.png" type="image/x-icon">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
	<link rel="stylesheet" type="text/css" href="../auth/css/util.css">
	<link rel="stylesheet" type="text/css" href="../auth/css/main.css">
	    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
</head>
<body>
	<div class="limiter">
		<div class="container-login100">
			<div class="wrap-login100 p-t-50 p-b-90">
				<form class="login100-form validate-form flex-sb flex-w" method="post">
					<span style="color: white" class="login100-form-title p-b-51">
						Login
					</span>

					
					<div class="wrap-input100 validate-input m-b-16">
						<input class="input100" type="text" name="keyauthusername" placeholder="Username" required>
						<span class="focus-input100"></span>
					</div>
					
					
					<div class="wrap-input100 validate-input m-b-16">
						<input class="input100" type="password" name="keyauthpassword" placeholder="Password" required>
						<span class="focus-input100"></span>

					</div>

                    <div class="wrap-input100 validate-input m-b-16">
						<input class="input100" name="keyauthtwofactor" placeholder="Two Factor Code (if applicable)">
						<span class="focus-input100"></span>
					</div>
					
					<div class="flex-sb-m w-full p-t-3 p-b-24">
						<div>
							<a href="../register/" class="txt1">
								Register
							</a>
						</div>

						<div>
							<a href="../forgot/" class="txt1">
								Forgot?
							</a>
						</div>
					</div>

					<div class="container-login100-form-btn m-t-17">
						<button name="login" class="login100-form-btn">
							Login
						</button>
					</div>

				</form>
			</div>
		</div>
	</div>
	
	
	
<style>
body {
    font-family: 'Poppins', sans-serif;
    background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
    background-image: url("https://i.imgur.com/1ahJiwL.jpeg");
    display: flex;
    align-items: center;
    justify-content: center;
    height: 100vh;
    margin: 0;
    overflow: hidden;
}

.container-login100 {
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    width: 100%;
    height: 100%;
}

.wrap-login100 {
    width: 100%;
    max-width: 400px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 20px;
    backdrop-filter: blur(10px);
    box-shadow: 0 4px 30px rgba(0, 0, 0, 0.2);
    padding: 50px 25px;
    box-sizing: border-box;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.wrap-input100 {
    margin-bottom: 16px;
    position: relative;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 12px;
    padding: 5px;
    box-shadow: inset 0 4px 6px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
}

.wrap-input100:hover {
    background: rgba(255, 255, 255, 0.1);
    box-shadow: inset 0 6px 8px rgba(0, 0, 0, 0.15);
}

.wrap-input100 .input100 {
    font-size: 1rem;
    width: 100%;
    padding: 12px 15px;
    border: none;
    border-radius: 10px;
    background: transparent;
    color: white;
    transition: all 0.3s ease;
}

.wrap-input100 .input100:focus, .wrap-input100 .input100:-webkit-autofill {
    outline: none;
    color: #ffffff;
    background: rgba(255, 255, 255, 0.2);
    box-shadow: inset 0 0 0px 1000px rgba(255, 255, 255, 0.1);
    -webkit-text-fill-color: #ffffff;
    transition: background-color 5000s ease-in-out 0s;
}

.wrap-input100 .focus-input100 {
    position: absolute;
    width: calc(100% - 10px);
    height: 2px;
    bottom: 5px;
    left: 5px;
    background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
    transform: scaleX(0);
    transform-origin: left;
    transition: transform 0.3s ease;
}

.wrap-input100 .input100:focus ~ .focus-input100 {
    transform: scaleX(1);
}

.wrap-input100 label {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    right: 15px;
    font-size: 1rem;
    color: rgba(255, 255, 255, 0.7);
    pointer-events: none;
    transition: color 0.3s;
}

.wrap-input100 .input100:focus ~ label {
    color: #ffffff;
}

.login100-form-btn {
    font-size: 1rem;
    width: 100%;
    padding: 12px;
    border: none;
    border-radius: 10px;
    background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
    color: white;
    cursor: pointer;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
}

.login100-form-btn:hover {
    background: linear-gradient(135deg, #2575fc 0%, #6a11cb 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.2);
}

.txt1 {
    color: rgba(255, 255, 255, 0.8);
    font-size: 0.9rem;
    text-decoration: none;
    transition: color 0.2s;
}

.txt1:hover {
    color: white;
}
</style>


<script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>

    <?php
        if (isset($_POST['login']))
        {
			
            if (empty($_POST['keyauthusername']) || empty($_POST['keyauthpassword']))
            {
                error("You must fill in all the fields!");
                return;
            }

            $username = sanitize($_POST['keyauthusername']);
            $password = sanitize($_POST['keyauthpassword']);

            ($result = mysqli_query($link, "SELECT * FROM `accounts` WHERE `username` = '$username'")) or die(mysqli_error($link));

            if (mysqli_num_rows($result) == 0)
            {
				error("Account doesn\'t exist!");
                return;
            }
                while ($row = mysqli_fetch_array($result))
                {
                    $user = $row['username'];
                    $pass = $row['password'];
                    $id = $row['ownerid'];
                    $email = $row['email'];
                    $role = $row['role'];
                    $app = $row['app'];
                    $isbanned = $row['isbanned'];
                    $img = $row['img'];
                    
                    $owner = $row['owner'];
                    $twofactor_optional = $row['twofactor'];
					$acclogs = $row['acclogs'];
					$google_Code = $row['googleAuthCode'];
                }

                if ($isbanned)
                {
                    error("Your account has been banned!");
					return;
                }
				
                    if (!password_verify($password, $pass))
                    {
                        error("Password is invalid!");
						return;
                    }
                            
                        if ($twofactor_optional)
                        {
                           // keyauthtwofactor
                           $twofactor = sanitize($_POST['keyauthtwofactor']);
                           if (empty($twofactor))
                           {
				  error("Two factor field needed for this acccount!");
                  return;
                           }

            require_once '../auth/GoogleAuthenticator.php';
			$gauth = new GoogleAuthenticator();
            $checkResult = $gauth->verifyCode($google_Code, $twofactor, 2);
            
            if (!$checkResult)
            {
				error("2FA code Invalid!");
				return;
			}
                        }

                        
                            $_SESSION['username'] = $username;
                            $_SESSION['email'] = $email;
                            $_SESSION['ownerid'] = $id;
                            $_SESSION['owner'] = $owner;
                            $_SESSION['role'] = $role;
                            
                            if($role == "Reseller" || $role == "Manager")
                            {
								($result = mysqli_query($link, "SELECT `secret` FROM `apps` WHERE `name` = '$app' AND `owner` = '$owner'")) or die(mysqli_error($link));
								if (mysqli_num_rows($result) < 1)
								{
									error("Application you\'re assigned to no longer exists!");
									return;
								}
								while ($row = mysqli_fetch_array($result))
								{
								$app = $row["secret"];
								}
                                $_SESSION['app'] = $app;
                            }
                            
                            $_SESSION['img'] = $img;
							
							if($acclogs) // check if account logs enabled
							{
							mysqli_query($link, "INSERT INTO `acclogs`(`username`, `date`, `ip`, `useragent`) VALUES ('".$_POST['keyauthusername']."','".time()."','$ip','".$_SERVER['HTTP_USER_AGENT']."')"); // insert ip log
							$ts = time() - 604800;
							mysqli_query($link, "DELETE FROM `acclogs` WHERE `username` = '" . $_POST['keyauthusername'] . "' AND `date` < '$ts'"); // delete any account logs more than a week old
							}
							
							// webhook start
								$timestamp = date("c", strtotime("now"));

								$json_data = json_encode([
									// Message
									"content" => "".$_SESSION['username']." has logged into KeyAuth with IP {$ip}",
									
									// Username
									"username" => "KeyAuth Logs",
								
								], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE );
								
								
								$ch = curl_init("webhook_link_here");
								curl_setopt($ch,CURLOPT_HTTPHEADER,array('Content-type: application/json'));
								curl_setopt($ch,CURLOPT_POST,1);
								curl_setopt($ch,CURLOPT_POSTFIELDS,$json_data);
								curl_setopt($ch,CURLOPT_FOLLOWLOCATION,1);
								curl_setopt($ch,CURLOPT_HEADER,0);
								
								curl_exec($ch);
								curl_close($ch);
								// webhook end
								
								mysqli_query($link, "UPDATE `accounts` SET `lastip` = '$ip' WHERE `username` = '$username'");
							                                     
							header("location: ../dashboard/");                           
}
    ?>
</body>
</html>