<?php

    include '../includes/connection.php';
    include '../includes/functions.php';
    session_start();

    if (isset($_SESSION['username'])) {
        header("Location: ../dashboard/");
        exit();
    }

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title>KeyAuth - Register</title>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="../assets/img/favicon.png" type="image/x-icon">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
	<link rel="stylesheet" type="text/css" href="../auth/css/util.css">
	<link rel="stylesheet" type="text/css" href="../auth/css/main.css">
</head>
<body>
	<div class="limiter">
		<div class="container-login100">
			<div class="wrap-login100 p-t-50 p-b-90">
				<form class="login100-form validate-form flex-sb flex-w" method="post">
					<span style="color: white" class="login100-form-title p-b-51">
						Register
					</span>

					
					<div class="wrap-input100 validate-input m-b-16">
						<input class="input100" type="text" name="username" placeholder="Username" minlength="2" required>
						<span class="focus-input100"></span>
					</div>
					
					<div class="wrap-input100 validate-input m-b-16">
						<input class="input100" type="email" name="email" placeholder="Email" required>
						<span class="focus-input100"></span>
					</div>
					
					
					<div class="wrap-input100 validate-input m-b-16">
						<input class="input100" type="password" name="password" minlength="5" placeholder="Password" required>
						<span class="focus-input100"></span>
					</div>
					<div class="flex-sb-m w-full p-t-3 p-b-24">

						<div>
							<a href="../login/" class="txt1">
								Already Registered?
							</a>
						</div>
					</div>

					<div class="container-login100-form-btn m-t-17">
						<button name="register" class="login100-form-btn">
							Register
						</button>
					</div>

				</form>
			</div>
		</div>
	</div>
	<style>
body {
    font-family: 'Poppins', sans-serif;
    background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
    background-image: url("https://i.imgur.com/1ahJiwL.jpeg");
    display: flex;
    align-items: center;
    justify-content: center;
    height: 100vh;
    margin: 0;
    overflow: hidden;
}

.container-login100 {
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    width: 100%;
    height: 100%;
}

.wrap-login100 {
    width: 100%;
    max-width: 400px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 20px;
    backdrop-filter: blur(10px);
    box-shadow: 0 4px 30px rgba(0, 0, 0, 0.2);
    padding: 50px 25px;
    box-sizing: border-box;
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.wrap-input100 {
    margin-bottom: 16px;
    position: relative;
    background: rgba(255, 255, 255, 0.05);
    border-radius: 12px;
    padding: 5px;
    box-shadow: inset 0 4px 6px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
}

.wrap-input100:hover {
    background: rgba(255, 255, 255, 0.1);
    box-shadow: inset 0 6px 8px rgba(0, 0, 0, 0.15);
}

.wrap-input100 .input100 {
    font-size: 1rem;
    width: 100%;
    padding: 12px 15px;
    border: none;
    border-radius: 10px;
    background: transparent;
    color: white;
    transition: all 0.3s ease;
}

.wrap-input100 .input100:focus, .wrap-input100 .input100:-webkit-autofill {
    outline: none;
    color: #ffffff;
    background: rgba(255, 255, 255, 0.2);
    box-shadow: inset 0 0 0px 1000px rgba(255, 255, 255, 0.1);
    -webkit-text-fill-color: #ffffff;
    transition: background-color 5000s ease-in-out 0s;
}

.wrap-input100 .focus-input100 {
    position: absolute;
    width: calc(100% - 10px);
    height: 2px;
    bottom: 5px;
    left: 5px;
    background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
    transform: scaleX(0);
    transform-origin: left;
    transition: transform 0.3s ease;
}

.wrap-input100 .input100:focus ~ .focus-input100 {
    transform: scaleX(1);
}

.wrap-input100 label {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    right: 15px;
    font-size: 1rem;
    color: rgba(255, 255, 255, 0.7);
    pointer-events: none;
    transition: color 0.3s;
}

.wrap-input100 .input100:focus ~ label {
    color: #ffffff;
}

.login100-form-btn {
    font-size: 1rem;
    width: 100%;
    padding: 12px;
    border: none;
    border-radius: 10px;
    background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
    color: white;
    cursor: pointer;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
}

.login100-form-btn:hover {
    background: linear-gradient(135deg, #2575fc 0%, #6a11cb 100%);
    transform: translateY(-2px);
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.2);
}

.txt1 {
    color: rgba(255, 255, 255, 0.8);
    font-size: 0.9rem;
    text-decoration: none;
    transition: color 0.2s;
}

.txt1:hover {
    color: white;
}
</style>
<script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>

  <?php
if (isset($_POST['register']))
{

    $username = sanitize($_POST['username']);

    $password = sanitize($_POST['password']);

    $email = sanitize($_POST['email']);

    $result = mysqli_query($link, "SELECT * FROM `accounts` WHERE `username` = '$username'") or die(mysqli_error($link));

    if (mysqli_num_rows($result) == 1)
    {
        error("Username already taken!");
        return;
    }

    $email_check = mysqli_query($link, "SELECT * FROM `accounts` WHERE `email` = '$email'") or die(mysqli_error($link));
    $do_email_check = mysqli_num_rows($email_check);

    if ($do_email_check > 0)
    {
        error('Email already used by username: ' . mysqli_fetch_array($email_check) ['username'] . '');
        return;
    }
    $pass_encrypted = password_hash($password, PASSWORD_BCRYPT);

    $ownerid = generateRandomString();

    $expires = time() + 3.154e+7; // set expiry to year in advance
    mysqli_query($link, "INSERT INTO `accounts` (`username`, `email`, `password`, `ownerid`, `role`, `app`, `owner`, `isbanned`, `img`,`balance`, `expires`, `registrationip`) VALUES ('$username', '$email', '$pass_encrypted', '$ownerid','tester','','',0,'https://i.imgur.com/TrwYFBa.png','1', '$expires', '$ip')") or die(mysqli_error($link));

    $_SESSION['username'] = $username;
    $_SESSION['email'] = $email;
    $_SESSION['ownerid'] = $ownerid;
    $_SESSION['role'] = 'tester';
    $_SESSION['img'] = 'https://keyauth.com/front/assets/img/favicon.png';
    mysqli_close($link);
    header("location: ../dashboard/");
}

?>
</body>
</html>